\def\filedate{2004/09/16}
\def\fileversion{1.0}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{gcg}[\filedate\space v\fileversion\space UWB in Pilsen GCG LaTeX document class]

\LoadClass[10pt,a5paper,twoside]{article}


\RequirePackage{graphicx}
\RequirePackage{fancyhdr}


\def\cesky{%
\def\abstractname{Abstrakt}
\def\keywordsname{Kl\'\i\v{c}ov\'a slova}
\RequirePackage[czech]{babel}
\RequirePackage[cp1250]{inputenc}
\def\refname{Literatura}}
\def\english{%
\def\refname{References}
\def\figurename{Fig.}
\def\abstractname{Abstract}
\def\keywordsname{Keywords}}


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% nastaveni fontu
%
%
\def\GCGfontsmall{\small\rm}
\def\GCGfontaddress{\footnotesize\itshape\bfseries}
\def\GCGfonttitle{\Large\bf}
\def\GCGfontauthor{\bf}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% nastaveni vzhledu stranky
%
\special{papersize=148mm,210mm}

\setlength{\paperwidth}{148mm}
\setlength{\paperheight}{210mm}

\setlength{\voffset}{-1.7cm}
\setlength{\topmargin}{0pt}
\setlength{\headheight}{5mm}
\setlength{\headsep}{3mm}

\setlength{\hoffset}{-1cm}
\setlength{\evensidemargin}{0pt}
\setlength{\oddsidemargin}{5mm}

\setlength{\textwidth}{112mm}
\setlength{\textheight}{180mm}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% changes in the article style
% ----------------------------
% changes sectioning headers (compare article.sty, art12.sty)
% zmenseni mezer pred a za nadpisem, zmena fontu nadpisu
%
\def\@seccntformat#1{\csname the#1\endcsname\ }
\renewcommand\section{\@startsection {section}{1}{\z@}%
    {-1.5ex plus -1ex minus -.2ex}%
    {0.5ex plus .2ex}% {0.5ex plus.2ex}%
    {\reset@font\large\bf}}
\renewcommand\subsection{\@startsection{subsection}{2}{\z@}%
    {-1.0explus -1ex minus- .2ex}% 3.25->3.0
    {0.5ex plus .2ex}%
    {\reset@font\normalsize\bf}}
\renewcommand\subsubsection{\@startsection{subsubsection}{3}{\z@}%
    {-1.0explus -1ex minus -.2ex}%
    {0.5ex plus .2ex}%
    {\reset@font\normalsize\bf}}
\renewcommand\paragraph{\@startsection{paragraph}{4}{\z@}%
    {1.0ex plus .2ex minus .2ex}%
    {-1em}%
    {\reset@font\normalsize\bf}}
\renewcommand\subparagraph{\@startsection{subparagraph}{5}{\parindent}%
    {1.0ex plus .2ex minus .2ex}%
    {-1em}%
    {\reset@font\normalsize\bf}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% changes list (itemize, ...) environment
%
\setlength\partopsep{0\p@ plus 0\p@ minus 0\p@}
\def\@listI{\setlength\leftmargin{\leftmargini}
    \setlength\parsep {\parskip}%
    \setlength\topsep {0\p@ plus 0\p@ minus 0\p@}%
    \setlength\itemsep{\smallskipamount}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definice zahlavi
%
%
\pagestyle{empty}
\fancyhead{}
\fancyfoot{}
\fancyhead[RE]{{\footnotesize \the\GCG@Author}}
\fancyhead[LE]{{\small \thepage}}
\fancyhead[LO]{{\footnotesize \the\GCG@ShortTitle}}
\fancyhead[RO]{{\small \thepage}}
\fancyfoot[CO,CE]{}
%\renewcommand{\headrulewidth}{1pt}
\headheight=16pt

\fancypagestyle{FirstPage}
{
  \fancyhead[LE,LO]{{\footnotesize Geometry and Computer Graphics 2006}}
  \fancyhead[RE,RO]{{\small \thepage}}
  \fancyfoot[CO,CE]{}
%  \renewcommand{\headrulewidth}{1pt}
  \headheight=16pt
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Definice promennych
%
%
\newtoks\GCG@Author
\newtoks\GCG@Title
\newtoks\GCG@ShortTitle
\newtoks\GCG@Abstract
\newtoks\GCG@Keywords
\newtoks\GCG@Address

%
% Makro pro pridavani retezce na konec toksu
%
% Pouziti:
%    \newtoks\mytoks
%    \mytoks{velk�} \totokse\mytoks{ pes}
%
%
\long\def\totokse#1#2{#1%
  \expandafter{\the#1#2}}

%
% Inicializace promennych
%
%
\GCG@Address={}%

%
% Definice prikazu pro prace s promennymi
%
%
\newcommand{\Author}[1]{\GCG@Author={#1}}
\newcommand{\Title}[1]{\GCG@Title={#1}}
\newcommand{\ShortTitle}[1]{\GCG@ShortTitle={#1}}
\newcommand{\Abstract}[1]{\GCG@Abstract={#1}}
\newcommand{\Keywords}[1]{\GCG@Keywords={#1}}
\newcommand{\Address}[3]{\totokse\GCG@Address{\smallskip #1 \par #2 \par #3 \par}}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Titulek clanku
%
%
\newcommand{\SetUpTitle}
{
  \thispagestyle{empty}
  \begin{center}
  {\GCGfonttitle \the\GCG@Title\\} \medskip
  {\GCGfontauthor \the\GCG@Author\\}
  {\GCGfontaddress \the\GCG@Address}
  \end{center}
  \begin{center}
    \begin{minipage}{0.9\textwidth}
%    \baselineskip=9pt
    \footnotesize
    {\small\textbf{\abstractname}. \the\GCG@Abstract\\[1ex]}
    {\small\textit{\keywordsname}: \the\GCG@Keywords\\}
    \end{minipage}
  \end{center}
}
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Modifikace literatury (zmenseni mezer)
%
%
\makeatletter
\renewcommand\@openbib@code{%
     \advance\leftmargin  \z@ %\bibindent
 %    \itemindent \bibindent
     \itemindent \z@
%     \listparindent -bibindent
     % Move bibitems close together
     \parsep -0.8ex %original value: \z@
     }
\makeatother
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



\endinput
